;ISR Routines

EXT_INT:	push r16			;save registers
			push r17

			in r16,SREG
			push r16			;save SREG

			;disable further interrupts
			in r16,GICR
			cbr r16,(1<<INT0 | 1<<INT1 | 1<<INT2)
			out GICR,r16			

			;flag keypad check
			ldi r16,low(626)
			ldi r17,high(626)
			mov Keypad_C0L,r16
			mov Keypad_C0H,r17	;Set counter to 626 (20ms)

			mov r16,Ticker_Flags
			sbr r16,(1<<Update_Keypad | 1<<Test_Keypad)
			mov Ticker_Flags,r16	;Set update and test flags
			
			pop r16
			out SREG,r16		;restore SREG

			pop r17
			pop r16				;restore registers

			reti

TMR0_OVF:	push r16			;save r16

			in r16,SREG
			push r16			;save SREG

			inc Ticker_Val

			pop r16
			out SREG,r16		;restore SREG

			pop r16				;restore r16

			reti

USART_RXC:	push r16			;save registers
			push r17
			push r18
			push r28
			push r29
			push r30
			push r31

			in r16,SREG
			push r16			;save SREG

			in r17,UCSRA		;read error flags
			in r16,UDR			;read data

			cbr r17,(1<<RXC | 1<<TXC | 1<<UDRE | 1<<U2X | 1<<MPCM)
			brne USART_RXC_End	;test error flags, exit if error found

			Set_FIFO_Address USART_RX_FIFO
			call FIFO_Write		;write UDR to the FIFO

USART_RXC_End:
			pop r16
			out SREG,r16		;restore SREG

			pop r31
			pop r30
			pop r29
			pop r28
			pop r18
			pop r17
			pop r16				;restore registers

			reti


USART_DRE:	push r16			;save registers
			push r17
			push r18
			push r28
			push r29
			push r30
			push r31

			in r16,SREG
			push r16			;save SREG

			Set_FIFO_Address USART_TX_FIFO
			ld r16,Z			;load USART_TX_FIFO counter value

			cpi r16,0x00
			brne USART_DRE_A	;break if FIFO counter !=0

			;FIFO counter = 0
			in r16,UCSRB
			cbr r16,(1<<UDRIE)
			out UCSRB,r16		;prevent further DRE interrupts

			mov r16,Immediate_Flags
			sbr r16,(1<<Test_TX_FIFO)
			mov Immediate_Flags,r16		;enable testing of TX counter

			rjmp USART_DRE_End

USART_DRE_A:
			;FIFO counter !=0
			call FIFO_Read		;get next data byte

			out UDR,r16			;send byte

USART_DRE_End:
			pop r16
			out SREG,r16		;restore SREG

			pop r31
			pop r30
			pop r29
			pop r28
			pop r18
			pop r17
			pop r16				;restore registers

			reti


ADC_INT:	push r16			;save registers
			push r17
			push r18
			push r19
			push r30
			push r31

			in r16,SREG
			push r16			;save SREG

			in r16,ADCL
			in r17,ADCH			;read ADC conversion result		

			in r18,ADMUX
			cbr r18,0b11111100	;only read the lowest two bits

			clr r19

			ldi ZL,low(ADC_INT_A)
			ldi ZH,high(ADC_INT_A)	;load jump table address

			add ZL,r18			;add MUX value
			adc ZH,r19

			ijmp				;indirect jump to jump table



ADC_INT_A:	rjmp ADC_INT_0
			rjmp ADC_INT_1
			rjmp ADC_INT_2
			rjmp ADC_INT_3


ADC_INT_0:	;ADC read channel 0

			;save ADC result
			ldi ZL,low(ADC0_Val)
			ldi ZH,high(ADC0_Val)

			st Z+,r16
			st Z,r17			;ADC result saved

			;set MUX
			in r18,ADMUX		;load MUX value
			cbr r18,0b00011111
			sbr r18,0b00000001
			out ADMUX,r18		;MUX = channel 1

			;if manaul control, set PWM
			sbrc DC2_B0,MC0
			out OCR0,r17		;PWM0 value = ADCH

			rjmp ADC_INT_End

ADC_INT_1:	;ADC read channel 1

			;save ADC result
			ldi ZL,low(ADC1_Val)
			ldi ZH,high(ADC1_Val)

			st Z+,r16
			st Z,r17			;ADC result saved

			;set MUX
			in r18,ADMUX		;load MUX value
			cbr r18,0b00011111
			sbr r18,0b00000010
			out ADMUX,r18		;MUX = channel 2

			;if manaul control, set PWM
			sbrc DC2_B0,MC1
			out OCR1AL,r17		;PWM1 value = ADCH

			rjmp ADC_INT_End

ADC_INT_2:	;ADC read channel 2

			;save ADC result
			ldi ZL,low(ADC2_Val)
			ldi ZH,high(ADC2_Val)

			st Z+,r16
			st Z,r17			;ADC result saved

			;set MUX
			in r18,ADMUX		;load MUX value
			cbr r18,0b00011111
			sbr r18,0b00000011
			out ADMUX,r18		;MUX = channel 3

			;if manaul control, set PWM
			sbrc DC2_B0,MC2
			out OCR1BL,r17		;PWM2 value = ADCH

			rjmp ADC_INT_End

ADC_INT_3:	;ADC read channel 3

			;save ADC result
			ldi ZL,low(ADC3_Val)
			ldi ZH,high(ADC3_Val)

			st Z+,r16
			st Z,r17			;ADC result saved

			;set MUX
			in r18,ADMUX		;load MUX value
			cbr r18,0b00011111
			sbr r18,0b00000000
			out ADMUX,r18		;MUX = channel 0

			;if manaul control, set PWM
			sbrc DC2_B0,MC3
			out OCR2,r17		;PWM3 value = ADCH

			rjmp ADC_INT_End


ADC_INT_End:
			;set IND pins
			in r16,PORTA
			cbr r16,0b11110000	;previous IND settings cleared

			mov r17,DC2_B0		;DC2,MC values if IND pins indicate manula control
			sbrc DC4_B0,INDC
			mov r17,DC4_B0		;DC2,INDN values if IND pins user controlled

			cbr r17,0b00001111	;new IND settings
			or r16,r17

			out PORTA,r16

			;start next conversion
			in r16,ADCSR		
			sbr r16,(1<<ADSC)
			out ADCSR,r16

			pop r16
			out SREG,r16		;restore SREG

			pop r31
			pop r30
			pop r19
			pop r18
			pop r17
			pop r16				;restore registers

			reti

EE_RDY:		push r16			;save registers
			push r17
			push r18
			push r28
			push r29
			push r30
			push r31

			in r16,SREG
			push r16			;save SREG

			Set_FIFO_Address EEPROM_FIFO
			ld r16,Z			;load EEPROM_FIFO counter value

			cpi r16,0x00
			brne EE_RDY_A	;break if FIFO counter !=0

			;FIFO counter = 0
			in r16,EECR
			cbr r16,(1<<EERIE)
			out EECR,r16		;prevent further interrupts

			mov r16,Immediate_Flags
			sbr r16,(1<<Test_EEPROM_FIFO)
			mov Immediate_Flags,r16		;enable testing of TX counter

			rjmp EE_RDY_End

EE_RDY_A:
			;FIFO counter !=0
			call FIFO_Read		;get next data byte

			lds r28,EEPROM_Write_Address
			lds r29,(EEPROM_Write_Address+1)

			adiw r29:r28,1			;increase address

			sts EEPROM_Write_Address,r28
			sts (EEPROM_Write_Address+1),r29 ;save address

			out EEARH,r29
			out EEARL,r28			;Set EEPROM address

			out EEDR,r16			;Set EEPROM Data

			sbi EECR,EEMWE
			sbi EECR,EEWE			;Start writing

EE_RDY_End:
			pop r16
			out SREG,r16		;restore SREG

			pop r31
			pop r30
			pop r29
			pop r28
			pop r18
			pop r17
			pop r16				;restore registers

			reti